<?php
/**
 * Plugin Name: VOYCELL Lead Connect
 * Plugin URI: https://voycell.com
 * Description: Allows site owners to integrate VOYCELL callback functionality by loading a VOYCELL-provided script URL.
 * Version: 1.2
 * Author: VOYCELL
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: voycell-lead-connect
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Add settings page
 */
add_action( 'admin_menu', 'voycell_add_settings_page' );
function voycell_add_settings_page() {
    add_options_page(
        'VOYCELL Lead Connect Settings',
        'VOYCELL Lead Connect',
        'manage_options',
        'voycell-lead-connect',
        'voycell_render_settings_page'
    );
}

/**
 * Add settings link on plugins page
 */
add_filter(
    'plugin_action_links_' . plugin_basename( __FILE__ ),
    'voycell_add_settings_link'
);
function voycell_add_settings_link( $links ) {
    $settings_link = '<a href="options-general.php?page=voycell-lead-connect">' . esc_html__( 'Settings', 'voycell-lead-connect' ) . '</a>';
    array_unshift( $links, $settings_link );
    return $links;
}

/**
 * Register settings
 */
add_action( 'admin_init', 'voycell_register_settings' );
function voycell_register_settings() {
    register_setting(
        'voycell_settings_group',
        'voycell_callback_url',
        'esc_url_raw'
    );

    register_setting(
        'voycell_settings_group',
        'voycell_user_consent',
        array(
            'type'    => 'boolean',
            'default' => false,
        )
    );
}

/**
 * Render settings page
 */
function voycell_render_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'VOYCELL Lead Connect Settings', 'voycell-lead-connect' ); ?></h1>

        <p>
            <?php esc_html_e( 'This plugin loads an external JavaScript file from VOYCELL to enable callback functionality.', 'voycell-lead-connect' ); ?>
        </p>

        <form method="post" action="options.php">
            <?php
            settings_fields( 'voycell_settings_group' );

            $callback_url = esc_attr( get_option( 'voycell_callback_url' ) );
            $consent      = (bool) get_option( 'voycell_user_consent' );
            ?>

            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="voycell_callback_url">
                            <?php esc_html_e( 'VOYCELL Script URL', 'voycell-lead-connect' ); ?>
                        </label>
                    </th>
                    <td>
                        <input
                            type="url"
                            name="voycell_callback_url"
                            id="voycell_callback_url"
                            value="<?php echo $callback_url; ?>"
                            class="regular-text"
                            placeholder="https://app.voycell.com/voycell_callback/xxxxxxxx"
                        />
                        <p class="description">
                            <?php esc_html_e( 'Enter the full script URL provided by VOYCELL.', 'voycell-lead-connect' ); ?>
                        </p>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php esc_html_e( 'User Consent', 'voycell-lead-connect' ); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" name="voycell_user_consent" value="1" <?php checked( $consent ); ?> />
                            <?php esc_html_e( 'I understand this plugin loads an external script from VOYCELL and consent to this behavior.', 'voycell-lead-connect' ); ?>
                        </label>
                    </td>
                </tr>
            </table>

            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

/**
 * Enqueue external script
 */
add_action( 'wp_enqueue_scripts', 'voycell_enqueue_callback_script' );
function voycell_enqueue_callback_script() {
    $url     = get_option( 'voycell_callback_url' );
    $consent = get_option( 'voycell_user_consent' );

    if ( ! empty( $url ) && $consent ) {
        wp_enqueue_script(
            'voycell-callback',
            esc_url( $url ),
            array(),
            null,
            true
        );
    }
}
